

function GetApnListService($resource,$q) {
	var self = this;
	this.getApnList = function getApnList(forceRefresh) {
		var deferred = $q.defer();
		var url = 'http://parc-du-vercors.fr/api/v1/randos';
		var requests = $resource(url, {}, {
					query : {
						method : 'GET',
						cache : true,
						isArray: false,
						params: {page:1,limit:15}
					}
				}, {
					stripTrailingSlashes : false
				});

		requests.query().$promise.then(function(data) {
					var data = angular.fromJson(data);
					deferred.resolve(data);
				});
				return deferred.promise;
	}
	
}

function GetApnService($resource,$q) {
	var self = this;
	this.getApn = function getApn(apnId) {
		var deferred = $q.defer();
		var url = 'http://parc-du-vercors.fr/api/v1/randos/' + apnId;
		var requests = $resource(url, {}, {
					query : {
						method : 'GET',
						cache : true
					}
				}, {
					stripTrailingSlashes : false
				});

		requests.query().$promise.then(function(data) {
					var data = angular.fromJson(data);
					deferred.resolve(data);
				});
				return deferred.promise;
	}
	
}

module.exports = {
	GetApnListService : GetApnListService,
	GetApnService : GetApnService
};

angular.module('rando.apn', [])
		.service('GetApnListService', require('./services').GetApnListService)
		.service('GetApnService', require('./services').GetApnService)
		.controller('ApnContentsListWidgetController',require('./controllers').ApnContentsListWidgetController)
		.controller('ApnContentWidgetController', require('./controllers').ApnContentWidgetController)
		.controller('ApnContentController', require('./controllers').ApnContentController)
		.directive('apnContentsList', require('./directives').apnContentsList)
		.directive('apnContent', require('./directives').apnContent);

var app = angular.module('geotrekRando');
app.requires.push('rando.apn');