'use strict';

function ApnContentsListWidgetController($scope,$modal, GetApnListService,GetApnService) {

	function init (forceReload){
		GetApnListService.getApnList(forceReload).then(
                function (data) {
                    $scope.apnList = data.items;
                    if (forceReload) {
                        $rootScope.$emit('apnListUpdated');
                    }
                }
            );
	}
	$scope.showLightbox = function showLightbox (id) {
		console.log(id);
		GetApnService.getApn(id).then(
                function (data) {
                    $modal.open({
			            template: require('./public/apn-content.html'),
			            controller: 'ApnContentController',
			            windowClass: 'apn-lightbox',
			            resolve: {
			                content: function () {
			                    return data;
			                }
			            }
			        });
                }
            );
		
	}
		
	init();
	
}

function ApnContentController($scope,content, $modalInstance){
	$scope.apnContent = content;
	$scope.close = function close () {
        $modalInstance.dismiss('close');
    };
}
module.exports = {
	ApnContentsListWidgetController : ApnContentsListWidgetController,
	ApnContentController : ApnContentController
};