'use strict';

/* SERVICE DECLARATION TEMPLATE

angular.module('rando.custom').service('nameOfYourService', function (aDependency, anotherDependency) {

    this.myMethod = function () {
        return 'Yeah it works !';
    };


});

/!\ the name of the module must be 'rando.custom', otherwise you'll get an error of a non existing module.

HINT: You can declare as many services as you whish

*/

function newsFeedService($q, $resource, $sce) {

    var self = this;
    var feedUrl = '';

    this.getFeed = function () {

        var deferred = $q.defer();



        if (self.newsFeed) {

            deferred.resolve(self.newsFeed);

        } else {
            var requests = $resource(feedUrl, {}, {
                query: {
                    method: 'GET',
                    cache: true,
                    isArray: true
                }
            }, {stripTrailingSlashes: false});

            requests.query().$promise
                .then(function (data) {
                    data = angular.fromJson(data);
                    var feed = [];
                    var tempNews;
                    for (var i = 0; i < 3; i++) {
                        tempNews = data[i];
                        tempNews.node_title = $sce.trustAsHtml(tempNews.node_title);
                        tempNews.chapeau = $sce.trustAsHtml(tempNews.chapeau);
                        feed.push(tempNews);
                    }
                    self.newsFeed = feed;
                    deferred.resolve(feed);
                });

        }

        return deferred.promise;

    };



}

angular.module('rando.custom').service('newsFeedService', newsFeedService);