'use strict';

function customRandomElementController($scope, resultsService, utilsFactory) {
    function getRandomContent() {
        resultsService.getRandomContentsByCategory($scope.category, 1)
            .then(
                function (randomContent) {
                    $scope.randomContent = randomContent[0];
                },
                function (err) {
                    console.error(err);
                }
            );
    }

    function init() {
        getRandomContent();
    }

    $scope.isSVG = utilsFactory.isSVG;
    $scope.sanitizeData = utilsFactory.sanitizeData;
    init();
}

function customNewsFeedController($scope, newsFeedService) {
    function initNewsFeed() {
        newsFeedService.getFeed()
            .then(
                function (newsFeed) {
                    $scope.newsFeed = newsFeed;
                },
                function (err) {
                    console.error('couldn\'t get news feed: ', err);
                }
            );
    }

    initNewsFeed();
}

angular.module('rando.custom').controller('customRandomElementController', customRandomElementController);
angular.module('rando.custom').controller('customNewsFeedController', customNewsFeedController);
